local WhiteStroke = color("1,1,1,0.5");
InitUserPrefs();

local t = Def.ActorFrame {
	AutoText("frutiger") .. {
		Name="SMVersion";
		InitCommand=cmd(x,SCREEN_RIGHT-20;y,SCREEN_TOP+20;horizalign,right;shadowlength,0;strokecolor,WhiteStroke;zoom,0.6;diffuse,color("0,0,0,1"));
		BeginCommand=function(self)
			local versionText = ProductFamily().." "..ProductVersion();
			versionColor = color("0,0.1,0.35,1")
			if VersionDate() then
				versionText = versionText .." (".. VersionDate() ..")";
			end;
			self:diffusetopedge( color("0.1,0.4,0.8,1") );
			self:settext(versionText);
		end;
	};

	AutoText("frutiger") .. {
		Name="Date";
		InitCommand=cmd(x,SCREEN_RIGHT-20;y,SCREEN_TOP+36;horizalign,right;shadowlength,0;strokecolor,WhiteStroke);
		BeginCommand=function(self)
			if MonthOfYear()+1 == 7 and DayOfMonth() == 11 then
				-- todo: localize me?
				self:settext("OMG FREE SLURPEES AT 7-11");
			else
				local themedString = THEME:GetString("ScreenTitleMenu","Today is %i/%i/%i.")
				self:settext( string.format(themedString,Year(),MonthOfYear()+1,DayOfMonth()) )
			end;
		end;
		OnCommand=cmd(diffuse,color("0,0,0,1");zoom,0.6);
	};
	AutoText("frutiger") .. {
		Name="Clock";
		InitCommand=cmd(x,SCREEN_RIGHT-20;y,SCREEN_TOP+52;horizalign,right;shadowlength,0;strokecolor,WhiteStroke);
		OnCommand=cmd(diffuse,color("0,0,0,1");zoom,0.6);
	};
	AutoText("frutiger") .. {
		Name="Network";
		InitCommand=cmd(x,SCREEN_RIGHT-20;y,SCREEN_TOP+68;horizalign,right;shadowlength,0;strokecolor,WhiteStroke);
		BeginCommand=function(self)
			if IsNetConnected() then
				self:settext(THEME:GetString("ScreenTitleMenu","Network OK!"));
			else
				self:settext(THEME:GetString("ScreenTitleMenu","Offline"));
			end
		end;
		OnCommand=cmd(diffuse,color("0,0,0,1");zoom,0.6;);
	};

	LoadActor("InstallData");

	AutoText("frutiger") .. {
		Name="Gametype";
		InitCommand=cmd(x,SCREEN_LEFT+10;y,SCREEN_TOP+64;horizalign,left;shadowlength,0;strokecolor,WhiteStroke);
		BeginCommand=function(self)
			self:settext( THEME:GetString("ScreenTitleMenu","Gametype:").." "..GAMESTATE:GetCurrentGame():GetName() )
		end;
		OnCommand=cmd(diffuse,color("0,0,0,1");zoom,0.6);
	};

	LoadActor("prefs")..{
		InitCommand=cmd(x,SCREEN_RIGHT+SCREEN_CENTER_X;y,SCREEN_CENTER_Y-72;horizalign,right);
		CodeMessageCommand=function(self,param)
			if param.Name == "SelectPress" then
				self:bouncebegin(0.375);
				self:x(SCREEN_RIGHT-124);
				self:sleep(5);
				self:bouncebegin(0.375);
				self:x(SCREEN_RIGHT+SCREEN_CENTER_X);
			end;
		end;
	};
};

local function Update(self)
	local clockDisp = self:GetChild("Clock");

	local hour = Hour();
	local minute = Minute();
	local sec = Second();
	clockDisp:settextf( THEME:GetString("ScreenTitleMenu","It's currently %02i:%02i:%02i."), hour, minute, sec );

	-- easter egg.
	if(hour == 4 or hour == 16) and min == 20 then
		clockDisp:diffuse( color("0,0.8,0,1") );
	else
		clockDisp:diffuse( color("0,0,0,1") );
	end;
end;

t.InitCommand=cmd(SetUpdateFunction,Update)

return t;